"Zero Chance of Recovery" by Andrew Schultz

volume headers

the story headline is "A story of hustle and redemption (sort of)".

the story description is "An implementation of a classic chess puzzle".

the release number is 1.

release along with the "Parchment" interpreter.

release along with a website.

release along with cover art.

include Old School Verb Total Carnage by Andrew Schultz.

include Trivial Niceties by Andrew Schultz.

include Conditional Undo by Jesse McGrew.

include Undo Output Control by Erik Temple.

include Bold Final Question Rows by Andrew Schultz.

include Intro Restore Skip by Andrew Schultz.

include Chessboard Rendering Utilities by Andrew Schultz.

include Zero Chance of Recovery Tests by Andrew Schultz.

volume game states and variables

game-state is a kind of value. the game-states are first-three-southwest, winnable, pawn-uncatchable, pawn-unguardable, nothing-works.

starting-king-moves is a number that varies. starting-king-moves is 0.

king-moves-left is a number that varies. king-moves-left is 0.

current-game-state is a game-state that varies.

black-move is a truth state that varies.

e6-local is a truth state that varies.

e6-solved is a truth state that varies.

to decide which number is square-val of (p - a person):
	if p is off-stage, decide on -1;
	let L be location of P;
	decide on (xval of L - 1) + (8 * (yval of L - 1));

to decide which number is game-hash:
	let temp be 16384 * boolval of black-move;
	increase temp by vert-val of white pawn * 2048;
	increase temp by vert-val of black pawn * 256;
	increase temp by square-val of the player * 64;
	decide on temp + square-val of black king;

chapter variables for specific try

moves-this-try is a number that varies.

to win-puzzle:
	if starting-king-moves is 0:
		say "Wait. No. You just dozed off a second. When you wake up, everything is as it was. But hey, you figured something out.";
		if e6-local is true, now e6-solved is true; [ 2 paths to victory in first scenario ]
	else if starting-king-moves is 1:
		say "Dang it.  Another reverie. But you've figured out a bit more.";
	else if starting-king-moves is 2:
		say "You feel like you've considered all the possible ways your enemy could react. And you can hold the line. But maybe there's something beyond that--into maybe a bit of deviousness--that could ruin the black king!";
	if starting-king-moves < 2, increment starting-king-moves;
	reset-puzzle;

to lose-puzzle:
	say "[one of]Fortunately, that was just a brief bad dream. You have a lot of them right after being knocked unconscious--they'll wear off eventually. Thankfully, here, it was just for a split-second or two, because that's how dreams work--hours of mind-time, almost no real time. Your exploits may have shown another way to do stuff wrong., though, and that might help with process of elimination[or]Ugh, another bad dream[stopping].";
	reset-puzzle;

to reset-puzzle:
	now early-south is false;
	now early-west is false;
	now black-move is false;
	now e6-local is false;
	now moves-this-try is 0;
	now black queen is off-stage;
	now white queen is off-stage;
	move white pawn to c6;
	move black pawn to h5;
	move black king to a6;
	move the player to h8;
	now king-moves-left is starting-king-moves;
	if starting-king-moves is 2:
		say "'[one of]Okay, this time, your[or]Your[stopping] pawn's a goner!' grumbles the black king. 'I'll just round it up, then my pawn's too far ahead of you. It'll run away from you if you get close. Easy-peasy.'";
	else if starting-king-moves is 1:
		say "The black king yells '[one of]You were almost clever there. [or][stopping]So I can't run my pawn down the board right away. But I can keep a closer eye on it. You still won't be able to keep track of both our pawns.'";
	else:
		first-intro;

to first-intro:
	say "'[one of]Ah! You awake? Then I can dispense with the chivalry and start giving orders. [or]Really! [stopping]All I have to do is get my pawn to run forward, and you can't do anything. Right? Still, it'll be fun to see you try,' booms the black king.";

volume when play begins

when play begins (this is the initialize everything rule):
	now max-scenario-moves is 7;
	now the right hand status line is "Scenario [starting-king-moves + 1]/3";
	say "Oh, what a gaffling it was! Everything went right. The only problem was, you weren't the assailant. You were peacefully minding your own business on f3, ready to track down the last opposing pawn, when all of a sudden ...";
	wfas;
	say "Mercenaries! So not on![paragraph break]'Dump him where, chief?'[paragraph break]'As far as possible. The corner. Dump him in a1? That's a bit farther. What? That'd cost extra [']cause it's so far away? No. No. You don't bargain with me like that. I can't give you payment up front if you're not willing to take the short trip to a1.'";
	wfas;
	say "A bargain happens, however. You're dizzy from the beating, so you're spared the details, mercifully. But when you wake up, it's apparent the king and mercenaries reached a compromise: you've been dumped in h8, and the mercenaries will receive no pay until the black pawn queens.";
	wfas;
	say "The enemy king booms 'You'll get payment when my final pawn queens! Yes, yes, that's a deal! Now, get off the battlefield. Chivalry and all that nonsense--I can't conduct war with you all on.' The mercenaries trot off slowly, giving you time to think and plan. You feel helpless, and yet... perhaps there is some way to save your skin or even turn the tables!";
	wfas;
	say "I mean, you have to try something, right? And maybe having relatively few possibilties, you might stumble on the right one by mistake!";
	wfas;
	clear the screen;

when play begins (this is the slightly custom screenread rule):
	now use-custom-screenread is true;
	say "[this-game] renders a chessboard in text maps for room descriptions. This will play very poorly with screen readers. In addition, you may prefer a text description to a chessboard as a matter of taste. Do you wish to activate text/screenreader mode?";
	if debug-state is false, ask-screenread;

volume the players

the player is in h8.

the white pawn is a friendly person in c6.

the black pawn is an enemy person in h5.

the black king is an enemy person in a6.

volume room description

to say text-board-description: [this varies from game to game]
	let my-piece be a random writeoutable person;
	say "You're currently at [location of player][if white pawn is not off-stage]. Your final remaining ally, the plucky white pawn at [location of white pawn], is being eyeballed closely by the enemy black king at [location of black king][end if].";
	say "[line break]The final black footsoldier is looking to streak down the side of the board. They're at [location of black pawn] right now";

after looking for the first time:
	say "[bracket][i][b]NOTE:[r] [i]if this is your first time playing, you may wish to see verbs with [b]VERBS[r][i], the rules and goals with [b]RULES[r][i] or [b]GOALS[r][i], or [b]ABOUT[r][i] for general information. Also, this puzzle is over one hundred years old, so I can only claim credit for the narrative adaptation, flimsy though it may be.[close bracket][r][paragraph break]";
	first-intro;

volume helper verb stuff

definition: a room (called r) is legal-king:
	unless r is adjacent to location of player, no;
	if white pawn is in r, no;
	if r is adjacent to location of black king, no;
	yes;

volume squaregoing

squaregoing is an action applying to one thing.

understand "[any room]" as squaregoing.

definition: a room (called rm) is goable:
	if rm is adjacent to location of player, yes;
	if white pawn is off-stage, no;
	if rm is the room north of location of white pawn, yes;
	no;

definition: a room (called rm) is king-goable:
	if rm is adjacent to the location of black king, no;
	if rm is adjacent to location of player, yes;
	if white pawn is not off-stage and rm is location of white pawn, no;
	no;

check squaregoing:
	if noun is a1 or noun is a8 or noun is h8:
		if player is in h8, say "This is chess, not Clue. There is no secret passage to the other corners." instead;
	unless noun is goable, say "You can't move to [noun][if white pawn is not off-stage], and neither can your pawn[end if]." instead;
	if white pawn is off-stage or noun is not the room north of location of white pawn or force-king is true:
		let D be the best route from location of the player to noun;
		try going D instead;
	if noun is not adjacent to enemy king, say "(assuming you meant the pawn)[line break]";
	try pawnpushing instead;
	if noun is adjacent to enemy king and noun is the room north of location of pawn, try pawnpushing instead;

chapter pawnpushing

pawnpushing is an action applying to nothing.

[		if location of black king is the room southeast of next-square:
			move black king to the room north of location of black king;
			say "The black king moves up a square to [location of black king].";
			the rule succeeds;]

understand the command "p" as something new;
understand "p" as pawnpushing.

check pawnpushing:
	if white pawn is off-stage, say "Your pawn has left the fight. You can't move them." instead;
	let next-square be the room north of location of white pawn;
	if location of black king is next-square, say "But the black king is blocking the way." instead;
	if game-hash is 15400:
		say "You freeze up for a moment. If black's pawn promotes and your promotes, then Queen to h3 skewers your queen! ... but wait, no, you queen with check. Whew.";
	if next-square is adjacent to location of black king:
		if next-square is not adjacent to location of white king:
			say "The enemy king laughs as he jumps your poor pawn just as it gets to [next-square]. You have no hope of catching the enemy pawn.";
			lose-puzzle;
			the rule succeeds;
	if location of white pawn is c7:
		if c8 is adjacent to black king and c8 is adjacent to white king:
			say "Your pawn promotes! It is a stalemate.";
			win-puzzle;
			the rule succeeds;
		if c8 is not adjacent to black king:
			say "Oops! This shouldn't happen. The pawn got too far ahead of the black king. This is a bug.";
			reset-puzzle;
			the rule succeeds;
		say "Unfortunately, after your pawn promotes, the enemy king tackles your pawn. You're not close enough to the enemy pawn.";
		lose-puzzle;
		the rule succeeds;
	move white pawn to c7;

volume meta verbs

to say ywg: say "[i]You Won't Get Her Back[r]"

check restarting the game: say "You have a vision of twelve-year-olds too lazy for battle crouching over a board yelling 'No fair! I get two out of three!' and 'No way! You lost so bad it was like two losses!' Weird.";

check saving the game: say "You record a moment in history. Or imagine you do. Pity there are no scribes around. They're too chicken for real combat.";

check quitting the game: say "You hear the black king laughing louder than he needs to.";

chapter abouting

abouting is an action out of world.

understand the command "about" as something new.

understand "about" as abouting.

carry out abouting:
	say "[this-game] was conceived July 2022, after submitting [ywg] for ParserComp 2022. My basic question was: could I make anything simpler than [ywg], yet still effective as a puzzle and story?";
	say "[line break]I could. [ywg] had to deal with rooks, kings and pawns. This only deals with kings and pawns. It's a tricky puzzle but one that's used to teach basic endgame principles, and I hope the story thrown in makes it fun. It's over a hundred years old, and since the name of the creator may be a potential spoiler, I'm going to wait on revealing it until the end.";
	say "[line break]Also, other people helped me with getting [this-game] out the door. You can see about their efforts with [b]CREDITS[r].";
	say "[line break]I welcome bug reports, big or small, as well as transcripts. [this-game]'s repository is at https://github.com/andrewschultz/zero-chance-of-recovery/issues. My email blurglecruncheon@gmail.com are also appreciated.";
	the rule succeeds;

chapter creditsing

creditsing is an action out of world.

understand the command "credits" as something new.

understand "credits" as creditsing.

carry out creditsing:
	say "Thanks to ClubFloyd the weekend before IFComp(!), wisprabbit and an anonymous tester for helping me to sand out bugs big and small. Those left are due to my own inattention and procrastination or lack of imagination.";
	say "[line break]A blanket thanks to everyone who helped me with [ywg], since this game sprang from that, including those who provided feedback.";
	say "[line break]Thanks to iconspng.com for the pawn vector images in the cover art and openclipart.com for the king, reused from [i]Fivebyfivia Delenda Est[r].";
	say "[line break]Also, thanks to anyone and everyone involved in administering IFComp over the years. It's helped me feel okay with thinking up and sending in games like this.";
	say "[line break]Also, thanks to the original creator of this now 100-year-old puzzle, and to whoever showed it to me in the first place. It's been a while.";
	the rule succeeds;

chapter restarting

restartiting is an action out of world.

understand the command "r" as something new.

understand "r" as restartiting.

carry out restartiting:
	if moves-this-try is 0, say "You already seem to be at the start[one of]! If not, this is a bug I'd like to know, but moving should fix that.[or]![stopping]" instead;
	say "Things blur. You wake up briefly and fall back asleep, but you can't help dreaming of what you need to do.";
	reset-puzzle;

chapter rulesing

rulesing is an action out of world.

understand the command "goals" as something new.
understand the command "rules" as something new.

understand "goals" as rulesing.
understand "rules" as rulesing.
understand "goals" as rulesing.
understand "rules" as rulesing.

carry out rulesing:
	say "You don't have to know all the rules of chess to 'win.' You just need to know how kings and pawns can move.[paragraph break]Kings can move up to eight squares. A pawn moves one square up or down the board. Also your pieces (white) are in upper case, and the black pieces are in lower case.";
	say "[line break]In this case, your pawn starts with two squares before it reaches its destination, where it can become a queen--you are going up the board. The opposing pawn starts at h5 and needs to move four squares. A king can touch any adjacent square, vertically or horizontally or diagonally. So in the corner at h8, you can go to three squares, but in the center of the board, you can go to eight.[paragraph break]Your goal in [this-game] is to either capture the enemy pawn or move your own pawn to the eighth rank.[paragraph break]It should be noted that capital letters are your pieces, and lower-case letters are your opponents['].";
	say "[line break]There is no penalty for getting thins wrong, so keep trying. [this-game] is solvable by trial-and-error, though such trial-and-error is not trivial.";
	if debug-state is true and the player's command includes "rules", say "[line break]Remember: [b]ROOLZ[r], not [b]RULES[r], is what to use in debug mode.";
	the rule succeeds;

chapter scoring

check requesting the score:
	say "There is no score, only whether or not you can catch your opponent's pawn or promote your own.[paragraph break]However, you are on scenario [starting-king-moves + 1 in words] of three[if starting-king-moves < 2]. Note that all three scenarios will have a similar start but pursue a different enemy strategy[end if].";
	the rule succeeds;

chapter thinking

the block thinking rule is not listed in any rulebook.

check thinking:
	say "Before you were knocked out, you remember the mercenaries and black king negotiating their deal: no payment unless the black pawn made it to h1 and promoted!";
	if starting-king-moves is 0:
		say "[line break]Why you remember this instead of any sort of combat plans to catch a fleeing enemy, you're not sure.";
		continue the action;
	say "[line break]You also remember some practical strategy, though.[paragraph break]When the enemy king stayed back, you achieved a draw as follows: g7, f6, [if e6-solved is true]e6[else]e7[end if], push the pawn, d7, promote the pawn.";
	if starting-king-moves > 1:
		say "[line break]You also remember how you tackled the black pawn when the enemy king moved in a bit. G7, then once the king moved, f6, e5, d6, push the pawn, d7, promote the pawn.";

chapter verbsing

verbsing is an action out of world.

understand the command "verbs" as something new.
understand the command "verb" as something new.
understand the command "v" as something new.

understand "verbs" as verbsing.
understand "verb" as verbsing.
understand "v" as verbsing.

carry out verbsing:
	say "[this-game] accepts commands in standard chess algebraic notation, which seems intimidating, but don't worry, you don't have to know the details. Also, you can use upper or lower case for your commands.";
	say "[line break]You are a king, which means you can move to any squares vertically, horizontally, or diagonally adjacent. That means if you are on c6, the commands [b]SE[r], [b]D5[r] and [b]KD5[r] would all move you to d5, assuming the square wasn't guarded or occupied. You can also move your pawn with [b]P[r] or type, say, [b]C7[r]. If both you and your pawn can move to a square, the pawn takes precedence.";
	say "[line break][b]R[r] resets the current scenario. [b]X[r] examines or gives your memories of a certain piece.";
	say "[line break]After typing meta-commands ([b]META[r] lists these)[if screenread is false] or toggling options (you can list them with [b]OPT[r],)[else],[end if] typing [b]L[r] or [b]LOOK[r] lets you see the board again.";
	say "[line break][if screenread is false]You can see options for board display with [b]OPT[r][else]With screen reader mode on, many text-map options are disabled[end if].";
	say "[line break]The commands above are in all caps to give them focus. The parser is case-insensitive.";

chapter xyzzying

xyzzying is an action out of world.

understand the command "xyzzy" as something new.

understand "xyzzy" as xyzzying.

carry out xyzzying:
	say "Well, yes, there could be a third game in this series starting with X. In fact, I thought of one a week before the IFComp 2022 deadline. Something to look forward to![paragraph break]Also, these magic words fail to open a 3-d wormhole that would move you quickly to h1, and no teleporting device appears. Guess it's all down to wit and hustle for you.";

chapter metaing

metaing is an action out of world.

understand the command "meta" as something new.

understand "meta" as metaing.

carry out metaing:
	say "[b]ABOUT[r] gives general information about [this-game].";
	say "[b]CREDITS[r] shows the credits.";
	say "[b]GOALS[r] and [b]RULES[r] both show how the pieces move as well as your goals for [this-game].";
	say "[b]META[r] is, well, this, and [b]OPTS[r] shows possible options. [b]VERBS[r] shows verbs.";
	say "[b]R[r] restarts a scenario if you think you've messed up.";
	say "[b]THINK[r] reconstructs how this whole affair started.";
	say "[line break]You should be able to use abbreviations for most or all of these meta-commands, but the full list is too numerous.";
	the rule succeeds;

chapter opting

opting is an action out of world.

understand the command "options" as something new.
understand the command "option" as something new.
understand the command "opts" as something new.
understand the command "opt" as something new.

understand "options" as opting.
understand "option" as opting.
understand "opts" as opting.
understand "opt" as opting.

carry out opting:
	say "You can toggle screen reader mode with [b]SCR[r]. In screen reader mode, [this-game] describes which pieces are where.";
	if screenread is true, say "[line break]There are no other options in screenreading mode. The ones that exist are for adjusting text maps." instead;
	say "[line break]You can toggle coordinates with [b]COO[r]/[b]COOR[r]/[b]COORD[r]/[b]COORDS[r] or set them specifically with [b]COO ON[r] or [b]COO OFF[r], etc.";
	say "[line break]You can also change the board square width with, say, [b]W 3[r] or [b]WIDTH 4[r]. Valid values are 1-5.";
	say "[line break]You can also toggle the inverse 'checkerboard' effect with [b]WB[r] or [b]WB ON[r] or [b]WB OFF[r].";
	say "[line break]The [b]HDR[r] command, along with a number, will put the board in the header. [b]HDX[r] uses xor on the number given.";
	the rule succeeds;

volume descriptions

description of player is "Very sweaty and such. You wonder how or if you still have the will and ability to chase after that last black pawn. And you were so close!";

description of white pawn is "[white-mood]."

to say white-mood:
	let H be horiz-val of player - horiz-val of white pawn;
	if H > 4:
		say "They are too far away to see their face.";
		continue the action;
	say "They seem to be looking [if h <= 2]hopefully[else]despairingly[end if] to their right at you, hoping for anything to save the day"

description of black pawn is "You can't see them very well from the [if vert-val of player <= vert-val of black pawn + 1]side and [end if]back. They're focused on the goal and know it's pointless to try and swivel their head to look at you."

description of black king is "[how-close].";

to say how-close:
	let H be horiz-val of player - horiz-val of black king;
	if H <= 2:
		say "The black king seems to have some of lost his confidence";
	else if H < 4:
		say "The black king seems to be smirking at how you are running around";
	else:
		say "At the moment, you can't see the black king's expression, which is probably for the best"

carry out xing when description of the noun is empty:
	if noun is off-stage, say "So far back in the past. You don't have time for memories right now!" instead;

volume parser stuff

force-king is a truth state that varies.

pawn-warn is a truth state that varies.

after reading a command:
	let X be the player's command in lower case;
	change the text of the player's command to "[X]";
	now force-king is false;
	if character number 1 in the player's command is "k" and the player's command matches the regular expression "^k<a-z><0-9>$":
		now force-king is true;
		strip-algebraic-front-letter;
	if pawn-warn is false:
		if character number 1 in the player's command is "p" and the player's command matches the regular expression "^p<a-z><0-9>$":
			now pawn-warn is true;
			say "NOTE: when moving pieces, it's assumed you're moving your pawn, though I should be able to pick up when you move your king as well.";
	if the player's command matches the regular expression "^p<a-z><0-9>$":
		let X be the player's command;
		replace the regular expression ".$" in X with "";
		change the text of the player's command to "[X]";
	if the number of words in the player's command > 1:
		if word number 1 in the player's command is "rules" or word number 1 in the player's command is "goals":
			change the text of the player's command to "goals";
	if the player's command includes "buy" or the player's command includes "pay" or the player's command includes "mercenaries":
		say "No, you can't hire the mercenaries to double-cross the black king. But maybe you could make them upset with him.";
		reject the player's command;

chapter parser errors

rule for printing a parser error (this is the general info error rule):
	say "Sorry, I couldn't parse that. In-game commands never need to be more than letters words long, and there are only limited moves to make. [this-game] can read algebraic notation, but you can just specify a square or, for your king, a direction to move.";
	say "[line break]Right now, you can ";
	process the print-legal-moves rule;
	if descriptive-warn is false:
		say "[line break]A final one-time note: the parser does not recognize descriptive notation. If you don't know what this means, don't worry. You're probably better off not knowing. But for chess players who wish to do so, sorry. I couldn't find any way to distinguish King to Bishop Seven from King to B7. Which was a convenient excuse to avoid an interesting coding puzzle.";
		now descriptive-warn is true;
	the rule succeeds;

definition: a direction (called di) is godirable:
	if the room di of location of player is goable, yes;
	no;

show-short-dirs is a truth state that varies.

for printing the name of a direction (called d) when show-short-dirs is true: say "[b][shorthand of d][r]"

this is the print-legal-moves rule:
	let pawn-square be the room north of location of white pawn;
	now king-go is true;
	say "move your king by typing [list of king-goable rooms] (the K can be eliminated";
	now king-go is false;
	if white pawn is not off-stage:
		say " unless you're going to [the room north of location of white pawn]";
	now show-short-dirs is true;
	say ") or type [list of godirable directions]";
	now show-short-dirs is false;
	say " to go [list of godirable directions]";
	if white pawn is not off-stage and location of black king is not pawn-square:
		say ". You can also type [b]P[r] or [b][printed name of pawn-square in upper case][r] to push the white pawn forward.";
	say "[line break]A more comprehensive list of commands is at [verb-say].";

volume going

to decide whether black-pawn-moves:
	showme starting-king-moves;
	showme moves-this-try;
	showme king-moves-left;
	showme early-west;
	showme early-south;
	showme vert-val of white king;
	showme vert-val of white pawn;
	showme vert-val of black king;
	showme vert-val of black pawn;
	if white pawn is off-stage, yes;
	if early-west is true, no;
	if early-south is true, yes;
	if king-moves-left > 0, no;
	if vert-val of white pawn > vert-val of black king, no;
	if starting-king-moves is 1:
		if moves-this-try is 2 or moves-this-try is 3, yes;
	if vert-val of white king - vert-val of black pawn >= 1:
		if location of white pawn is adjacent to location of black king and location of white pawn is not adjacent to location of white king, no;
	repeat through table of king forced moves:
		if what-state entry is game-hash:
			if pawn-move entry is true, yes;
			no;
	if location of white pawn is c7:
		if location of black king is adjacent to location of white pawn and location of white king is not adjacent to location of white pawn, no; [TAKE THE PAWN]
	if king-moves-left > 0, no;
	yes;

table of king forced moves
what-state	pawn-move
15857	true
16369	true
15400	true

check going (this is the reject guarded and occupied squares rule):
	if number of friendly people in the room gone to is 1, say "You can't go to [room gone to], since [the random friendly person in room gone to] occupies it." instead;
	if the room gone to is adjacent to location of black king, say "On [room gone to], you'd be too close to the black king on [location of black king]." instead;

check going when black pawn is in room gone to (this is the catch the black pawn rule):
	say "The black pawn is nowhere near strong enough for you! Down it goes! [if white pawn is off-stage]Revenge for your own pawn![else]The black king takes out your pawn as well, but hey, you broke even[one of]. You didn't think you could[or] again[stopping].[end if]";
	win-puzzle;
	the rule succeeds;

early-west is a truth state that varies.
early-south is a truth state that varies.

check going (this is the check early blunders rule):
	increment moves-this-try;
	if moves-this-try > 2 or noun is southwest, continue the action;
	if (noun is west or noun is northwest), now early-west is true;
	if (noun is south or noun is southwest), now early-south is true;
	now early-south is true;

to decide whether near-pawn:
	if vert-val of black pawn is vert-val of player - 1, yes;
	no;

to decide whether in-the-square:
	if vert-val of black pawn < vert-val of player, no;
	if (horiz-val of black pawn - horiz-val of player) > (vert-val of black pawn - 1), no;
	yes;

this is the pawn-move rule:
	say "The black king orders his pawn to move down the board, [if in-the-square]as it could still outrun you, maybe[else if near-pawn]or you will catch it[else]just to keep way ahead[end if].";
	try the black pawn going south;
	if location of black pawn is not h1, continue the action;
	say "And the pawn, reaching the end of the board, becomes a queen.";
	now black pawn is off-stage;
	now black queen is in h1;
	if white pawn is in c7:
		if location of player is adjacent to c8:
			say "But you are able to shepherd your own pawn on the next turn, and it becomes a queen, too! The whole war is a draw.";
			win-puzzle;
			the rule succeeds;
	if location of player is d6 and location of black king is adjacent to c8:
		say "You're guarding the pawn for now, but all the black queen has to do is check you and take the pawn, since she's guarded by the king. And she does. And the king and queen trap you. You must have been close--you made up so much ground, but not quite enough!";
		lose-puzzle;
		the rule succeeds;
	if location of player is not adjacent to h1:
		say "[line break]There's nothing you can do but watch as the queen swoops past you and [if player is not in f2 and player is not in g3]eventually [end if]boxes you in where you can only shuffle between h1 and g1. The black king approaches to assist the queen in checkmating you.";
		lose-puzzle;
		the rule succeeds;
	if starting-king-moves is 2:
		say "Your opponent groans. 'Okay, so the war is a stalemate.'";
		say "[line break]But wait! Thundering hooves! The mercenaries he hired have ridden back to demand payment! After all, it was immediately due once the pawn queened. There was no fine print about whether the pawn had to survive. So while the war is a stalemate, the enemy king is in a lot of trouble with the mercenaries.";
		end the story finally saying "A strategic victory!";
		the rule succeeds;
	say "[line break]The enemy king shrugs his shoulders, and yet he almost looks fearful, not just annoyed you let the pawn queen. You think you hear him arguing with the mercenaries that hired you. He argued the failure was their fault, and he can't pay them, because ...[paragraph break]... you can't hear the rest. But what if he was forced to pay them? Perhaps how you tackle the pawn matters?";
	win-puzzle;
	the rule succeeds;

this is the make-black-move rule:
	d "[game-hash] game hash.";
	if black-pawn-moves:
		abide by the pawn-move rule;
	else:
		abide by the king-move rule;
	continue the action;

after going (this is the black's turn to move rule):
	if location of player is e6, now e6-local is true;
	abide by the make-black-move rule;
	continue the action;

after pawnpushing:
	abide by the make-black-move rule;
	try looking;
	continue the action;

this is the king-move rule:
	if king-moves-left > 0, decrement king-moves-left;
	if black king is in a6:
		let x be the room west of location of white pawn;
		say "The black king slides to [x], uncomfortably close to your pawn on [location of white pawn].";
		if starting-king-moves > 0, say "[line break]'Ha-ha. Just guarding the pawn a bit. I can always take it later.'";
		move black king to x;
		continue the action;
	if location of black king is adjacent to location of white pawn:
		if location of white king is not adjacent to location of white pawn:
			say "The black king takes your pawn and laughs. You can't win now! But can you stop the black pawn?";
			move black king to location of white pawn;
			now white pawn is off-stage;
			continue the action;
		if black king is in b6 and white pawn is in c7 and c7 is adjacent to location of white king:
			say "The black king slides to b7.";
			move black king to b7;
			continue the action;
		say "Uh-oh, I don't know what to do here: [game-hash].";
		reset-puzzle;
	say "HELP! I don't know what to do.";
	the rule succeeds;

volume allow player to type RULES

Include (-

[ testcommandnoun obj o2;
	switch (scope_stage) {
		1: rtrue; ! allow multiple objects
		2: objectloop (obj)
			if ((obj ofclass Object) && (obj provides KD_Count))
				PlaceInScope(obj, true);
		3: print "There seems to be no such object anywhere in the model world.^";
	}
];

{-testing-command:abstract}
	* scope=testcommandnoun 'to' scope=testcommandnoun -> XAbstract;
{-testing-command:actions}
	*                                           -> ActionsOn
	* 'on'                                      -> ActionsOn
	* 'off'                                     -> ActionsOff;
{-testing-command:gonear}
	* scope=testcommandnoun                     -> Gonear;
{-testing-command:purloin}
	* scope=testcommandnoun                     -> XPurloin;
{-testing-command:random}
	*                                           -> Predictable;
{-testing-command:relations}
	*                                           -> ShowRelations;
{-testing-command:roolz}
	*                                           -> RulesOn
	* 'all'                                     -> RulesAll
	* 'on'                                      -> RulesOn
	* 'off'                                     -> RulesOff;
{-testing-command:scenes}
	*                                           -> ScenesOn
	* 'on'                                      -> ScenesOn
	* 'off'                                     -> ScenesOff;
{-testing-command:scope}
	*                                           -> Scope
	* scope=testcommandnoun                     -> Scope;
{-testing-command:showheap}
	*                                           -> ShowHeap;
{-testing-command:showme}
	*                                           -> ShowMe
	* scope=testcommandnoun                     -> ShowMe;
{-testing-command:showverb}
	* special                                   -> Showverb;
{-testing-command:test}
	*                                           -> TestScript
	* special                                   -> TestScript;
{-testing-command:trac}
	*                                           -> TraceOn
	* number                                    -> TraceLevel
	* 'on'                                      -> TraceOn
	* 'off'                                     -> TraceOff;
{-testing-command:tree}
	*                                           -> XTree
	* scope=testcommandnoun                     -> XTree;

-) instead of "Grammar" in "Tests.i6t".
